<?php
add_action('wp_footer', function () {
    if (isset($_COOKIE['gads_cookie_consent'])) return;

    $options = get_option('gads_cookie_settings');
    if (empty($options['gads_cookie_enabled'])) return;

    $message = $options['gads_cookie_message'] ?? 'جهت بهبود خدمات از کوکی ها استفاده می‌کنیم.';
    $accept_text = $options['gads_cookie_accept_text'] ?? 'پذیرفتن';
    $color = $options['gads_cookie_color'] ?? '#28B446';
    $position = $options['gads_cookie_position'] ?? 'bottom-left';

    $position_style = $position === 'bottom-left' ? 'left: 20px;' : 'right: 20px;';
    ?>
    <div id="gads-cookie-banner" style="position: fixed; bottom: 20px; <?php echo esc_attr($position_style); ?> background: #fff; box-shadow: 0 0 20px rgb(0 0 0 / 15%); padding: 15px; border-radius: 8px; z-index: 9999; max-width: 300px; font-family: inherit;font-size: 0.9em;">
        <div style="margin-bottom: 10px;"><?php echo esc_html($message); ?></div>
        <div class="gaads-cookie-footer" style="text-align: left;">
            <button id="gads-cookie-accept" style="background-color: <?php echo esc_attr($color); ?>; color: #fff; font-size: 0.9em; padding: 5px 10px; border: none; cursor: pointer; border-radius: 5px;"><?php echo esc_html($accept_text); ?></button>
            <a href="<?php echo esc_url(site_url('/privacy-policy')); ?>" target="_blank" style="color: #0073aa; text-decoration: underline;font-size: 0.9em;margin-right: 10px;"><?php echo esc_html('اطلاعات بیشتر', 'gads-cookie'); ?></a>
        </div>
    </div>
    <script>
        document.getElementById('gads-cookie-accept').addEventListener('click', function () {
            document.getElementById('gads-cookie-banner').style.display = 'none';
            document.cookie = "gads_cookie_consent=1; path=/; max-age=" + (60 * 60 * 24 * 365);
        });
    </script>
    <?php
});